<?php

namespace App\Http\Controllers;

use App\Models\SalasInversion; 
use App\Models\Promociones; 
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse; 
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\View; 
use Carbon\Carbon;
use Mail;
use DB;
use Auth;

class PromocionesController extends Controller
{
 
    public function AddPromociones()
    {
        
        return view('salas_inversion.registro');
        
    }

 
    public function EditsPromociones($id)
    { 
        $salas_inversion = Promociones::find($id);
        $promociones = DB::select('SELECT * FROM promociones WHERE promociones.id_sala = ? ORDER BY  id ASC ', [$id]);
        return view('salas_inversion.actualizar',compact(
                'salas_inversion',
                'promociones'
        ));
        
    }

    public function UpdatePromociones(Request $request)
    { 
        
        $promociones = Promociones::find($request->input('id')); 
        $promociones->descripcion=$request->input('descripcion');  
        $promociones->comentarios=$request->input('comentarios');        
        $promociones->porcentaje=$request->input('porcentaje');  
        $promociones->fecha_ini=Carbon::parse($request->input('fecha_ini'))->format('Y-m-d');
        $promociones->fecha_fin=Carbon::parse($request->input('fecha_fin'))->format('Y-m-d');      

        if ( $request->file('attachment_1')){            

            $filename = sha1($request->file('attachment_1')->getClientOriginalName() . uniqid() . getrandmax()). '.' . $request->file('attachment_1')->getClientOriginalExtension();

            Storage::put($filename, file_get_contents($request->file('attachment_1')->getRealPath()),'public'); 
            $size = Storage::size($filename);

            $promociones->archivo_1 = $filename;  
        } 

        $promociones->save(); 
  

        return new RedirectResponse(url('/sala_inversion/edit/'.$promociones->id_sala));

    }

    /**
     * Update the specified resource in storage.
     */
   
   
    public function delete_promocion(Request $request)
    {  
        $promocion = Promociones::find($request->input('id')); 
        $promocion->delete();
  
        return back();
         
        
    }


         public function store_file_promocion_detalle(Request $request){

        //dd($request->all());

 
        $promociones = new Promociones();
        $promociones->id_sala=$request->input('id_sala');  
        $promociones->descripcion=$request->input('descripcion');  
        $promociones->comentarios=$request->input('comentarios');        
        $promociones->porcentaje=$request->input('porcentaje');  
        $promociones->fecha_ini=Carbon::parse($request->input('fecha_ini'))->format('Y-m-d');
        $promociones->fecha_fin=Carbon::parse($request->input('fecha_fin'))->format('Y-m-d');      

        if ( $request->file('attachment_1')){            

            $filename = sha1($request->file('attachment_1')->getClientOriginalName() . uniqid() . getrandmax()). '.' . $request->file('attachment_1')->getClientOriginalExtension();

            Storage::put($filename, file_get_contents($request->file('attachment_1')->getRealPath()),'public'); 
            $size = Storage::size($filename);

            $promociones->archivo_1 = $filename;  
        } 

        $promociones->save(); 

         
        return new RedirectResponse(url('/sala_inversion/edit/'.$request->input('id_sala')));
    }


    
}
