<?php

namespace App\Http\Controllers;

use App\Models\Users; 
use App\Models\Perfil;
use App\Models\Transacciones;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use DB;
use Illuminate\Http\RedirectResponse;
use App\Mail\SendMail_Verificacion; 
use App\Mail\SendMail_Pago; 
use Mail;


class UsersAdminController extends Controller
{
    /**
     * Display a listing of the resource.
     */

    public function ListAdminusers()
    {
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')        
        ->where('users.current_team_id', '=', 1)  
          ->get(['users.id AS id_u_user', 
            'perfiles.nombre as socios_nombre', 
            'perfiles.profile_photo_path as socios_profile_photo_url', 
            'users.name as user_name', 
            'users.email as user_email', 
            'users.created_at as created_at', 
            'users.status as status', 
            'users.current_team_id as user_current_team_id' ]);   

      $tipo_user = "Administradores";


       // dd($users);
        return view('users.catalogo',compact('users','tipo_user'));
        
    }

    public function AddAdminusers()
    {  
        $perfiles = Perfil::paginate(20);
        
        return view('users.registro',compact('perfiles'));
        
    }

    public function SaveAdminusers(Request $request)
    { 

       // dd($request->input('name'));
    
        $user = new Users();
        $user->name=$request->input('name');        
        $user->email=$request->input('email');                          
        $user->current_team_id=$request->input('current_team_id');                          
        $user->password=Hash::make($request->input('password')); 

        $user->save();

 
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')        
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.current_team_id as user_current_team_id' ]);   
 
        return new RedirectResponse(url('/user_admin/list'));
    }

    public function EditAdminusers($id)
    { 
        $users = Users::find($id); 
        $perfiles = Perfil::paginate(20);

        $transacciones =  DB::table('transacciones')       
        ->join('users', 'transacciones.id_user', '=' ,'users.id')  
        ->leftJoin('bancos', 'users.id_banco', '=' ,'bancos.id')   
        ->leftJoin('salas_inversion', 'transacciones.id_sala', '=' ,'salas_inversion.id')  
        ->leftJoin('salas_inversion_capitalizacion', 'transacciones.id_sala_capitalizacion', '=' ,'salas_inversion_capitalizacion.id')  
        ->where('transacciones.id_user', '=', $id) 
        ->get([
        'transacciones.*',        
        'bancos.nombre as banco_nombre', 
        'bancos.clave as banco_clave' ]); 

        return view('users.actualizar',compact('users','perfiles','transacciones'));
        
    }

    public function UpdateAdminuser(Request $request)
    { 
        
        $user = Users::find($request->input('id')); 
        $user->name=$request->input('name');        
        $user->email=$request->input('email');                          
        $user->current_team_id=$request->input('current_team_id');        
         if ( $request->input('password')){
                     $user->password=Hash::make($request->input('password'));  
         }
   
        $user->save();



        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')        
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.current_team_id as user_current_team_id' ]);   

       // dd($users);  
        return new RedirectResponse(url('/user_admin'));
    
}

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
       public function destroy(string $id)
    {
        $user = Users::find($id); 
        $user->delete();
        $users = Users::paginate(20);
        return view('user.catalogo',compact('user'));
    }

     public function DestroyAdminuser(string $id)
    {
        $user = Users::find($id); 
        $user->delete();
        return back();
    }


      public function Statususer(Request $request){
 
            $id_user = $request->input('id_user');  
            $user = Users::find($id_user);
            if($user->status==1)
                $user->status=0;
            else
                $user->status=1;
            $user->save();

        return new RedirectResponse(url('/user'));

       
    }

    public function ValidarCuenta(Request $request){
 
            $id_user = $request->input('id_user');  
            $user = Users::find($id_user);  


            switch ($request->guardar_btn) {
            case 'cambio_estatus_aprobar':

                $user->cuenta_validada=3; 
                $user->save();

               /******** ENVIO MAIL ************************/ 

                $send_mail = $user->email;  
                $usuario_genera = "registro_usuarios@invercai.com";  
                $mensaje = "Su cuenta ha sido Verificada Satisfactoriamente";

               Mail::to($send_mail)->send(new SendMail_Verificacion($usuario_genera, $mensaje));


                return new RedirectResponse(url('/dashboard'));
        
             break;

             case 'cambio_estatus_rechazar':
                  
                $user->cuenta_validada=2; 
                $user->save();

                /******** ENVIO MAIL ************************/ 

                $send_mail = $user->email;  
                $usuario_genera = "registro_usuarios@invercai.com";  
                $mensaje = "Su cuenta ha sido Verificada Rechazada";

               Mail::to($send_mail)->send(new SendMail_Verificacion($usuario_genera, $mensaje));


                return new RedirectResponse(url('/dashboard'));
  
             break;
        }


}
         public function ValidarPago(Request $request){
 
            $id_transaccion = $request->input('id_transaccion');  
            $transaccion = Transacciones::find($id_transaccion);  
            $user = Users::find($transaccion->id_user);  


            switch ($request->guardar_btn) {
            case 'cambio_estatus_aprobar':

                $user->balance =  $user->balance - $transaccion->balance;
                $user->balance_interes =  $user->balance_interes - $transaccion->balance_interes;
                $user->save();

                $transaccion->status=3; 
                $transaccion->save();

                /******** ENVIO MAIL ************************/ 

                $send_mail = $user->email;  
                $usuario_genera = "registro_usuarios@invercai.com";  
                $mensaje = "El pago a su cuenta fue exitoso por el siguiente monto:";
                $pago =  "$" . number_format($transaccion->pago, 2, '.', ',');
                $status =  "Aprobada";

                Mail::to($send_mail)->send(new SendMail_Pago($usuario_genera, $mensaje, $pago, $status));

                return new RedirectResponse(url('/dashboard'));
        
             break;

             case 'cambio_estatus_rechazar':
                  
                $transaccion->status=2; 
                $transaccion->save();

                /******** ENVIO MAIL ************************/ 

                $send_mail = $user->email;  
                $usuario_genera = "registro_usuarios@invercai.com";  
                $mensaje = "Su solicitud de pago fue rechazada:";
                $pago =  "$" . number_format($transaccion->pago, 2, '.', ',');
                $status =  "Rechazada";

                Mail::to($send_mail)->send(new SendMail_Pago($usuario_genera, $mensaje, $pago, $status));

                return new RedirectResponse(url('/dashboard'));
  
             break;
        }

}
public function exportarTxt()
{
    // Obtener datos de Eloquent 

    $usuarios =  DB::table('users')       
        ->join('transacciones', 'transacciones.id_user', '=' ,'users.id')  
        ->join('bancos', 'users.id_banco', '=' ,'bancos.id')  
        ->where('transacciones.tipo_pago', '=', 4)  
        ->where('transacciones.status', '=', 1)  
        ->get([
        'transacciones.descripcion AS descripcion',  
        'transacciones.id AS id_transaccion',  
        'transacciones.pago AS pago',  
        'transacciones.created_at AS fecha_solicitud',  
        'transacciones.status AS pago_status',  
        'transacciones.balance AS balance',  
        'transacciones.balance_interes AS balance_interes',  
        'users.id AS id_u_user',  
        'users.name as user_name', 
        'users.email as user_email', 
        'users.created_at as created_at', 
        'users.status as status', 
        'users.cuenta_validada as cuenta_validada', 
        'users.clabe_banco as clabe_banco', 
        'users.id_banco as id_banco', 
        'users.nombre_banco as nombre_banco', 
        'bancos.nombre as banco_nombre', 
        'bancos.clave as banco_clave', 
        'users.current_team_id as user_current_team_id' ]); 



    // Convertir colección a texto
    $contenido = "";

    foreach ($usuarios as $usuario) {

        $tipo_transferencia = "";

        $cuenta_destinataria = str_pad($usuario->clabe_banco, 18, '0', STR_PAD_LEFT);
        if($usuario->id_banco == 26)
            $tipo_transferencia = "PTC";
        $cuenta_origen = "000000000125583047";
        $divisa = "MXN";
        $importe = str_pad(number_format($usuario->pago, 2, '.', ''), 16, '0', STR_PAD_LEFT);
        $titular = str_pad($usuario->nombre_banco, 30, ' ', STR_PAD_RIGHT);
        $tipo = "40"; 
        $banco_clave = substr($usuario->banco_clave, -3);
        $concepto = "SOLICITUD DE RETIRO           ";
        $id_transaccion = str_pad($usuario->id_transaccion, 7, '0', STR_PAD_LEFT);
        $clave_disponibilidad = "H"; 

        $contenido .= $tipo_transferencia . $cuenta_destinataria . $cuenta_origen . $divisa . $importe . $titular . $tipo . $banco_clave . $concepto . $id_transaccion . $clave_disponibilidad ."\n";

        /****
        
        /***/


        $transaccion = Transacciones::find($usuario->id_transaccion);  
        $transaccion->status=4; 
        $transaccion->fecha_descarga=Carbon::now('America/Mexico_City'); 
        $transaccion->save();
    }

    // Nombre del archivo
    $fileName = "pagos_" . date('Ymd_His') . ".txt";

    // Retornar archivo para descargar
    return response($contenido)
        ->header('Content-Type', 'text/plain')
        ->header('Content-Disposition', 'attachment; filename="'.$fileName.'"');
 

}


public function aplicarPagoTxt()
{
    // Obtener datos de Eloquent  

        $transacciones = Transacciones::where('tipo_pago', 4)
                            ->where('status', 4)
                            ->get();

    foreach ($transacciones as $transacciones) {
        $user = Users::find($transacciones->id_user); 
        $user->balance =  $user->balance - $transacciones->balance;
        $user->balance_interes =  $user->balance_interes - $transacciones->balance_interes;
        $user->save();

        /******** ENVIO MAIL ************************/ 

        $send_mail = $user->email;  
        $usuario_genera = "registro_usuarios@invercai.com";  
        $mensaje = "El pago a su cuenta fue exitoso por el siguiente monto:";
        $pago =  "$" . number_format($transacciones->pago, 2, '.', ',');
        $status =  "Aprobada";

        Mail::to($send_mail)->send(new SendMail_Pago($usuario_genera, $mensaje, $pago, $status));

        /******** CAMBIOS STATUS  ************************/ 

        $transacciones->status = 3;
        $transacciones->save();
    }

 

    // Retornar archivo para descargar 
    return new RedirectResponse(url('/dashboard'));
 
}


       
    
}
