@extends('admin.admin_dashboard')
@section('content')
				

     <section class="pc-container">
      <div class="pc-content">
        <!-- [ breadcrumb ] start -->
        <div class="page-header">
          <div class="page-block">
            <div class="row align-items-center"> 
              <div class="col-md-12">
                <div class="page-header-title">
                  <h2 class="mb-0">Salas Inversión</h2>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- [ breadcrumb ] end -->
        <div class="row">

          <!-- DOM/Jquery table start -->
          <div class="col-sm-12">
            <div class="card"> 
              <div class="card-body"> 
                <div class="text-end p-4 pb-0"> 
 
                <a  href="{{ route('sala_inversion/add')}}"  class="btn btn-primary">Agregar Sala de Inversión</a>

                       </div>
                <div class="table-responsive dt-responsive">
                  <table id="table-inventory-cat" class="table table-striped table-bordered">
                    <thead>
                      <tr>
                        <th class="text-center">Valor $ MXN</th> 
                        <th class="text-center">No. Sala</th>
                        <th class="text-center">Descripción</th> 
                        <th class="text-center">% Invitación Directa</th>  
                        <th class="text-center">% Interés Compuesto</th>  
                        <th class="text-center">% Sala de Espera</th>   
                      </tr>
                    </thead>
                    <tbody>
                    @foreach($salas_inversion as $salas_inversion)                   

                      <tr>     
                        <td class="text-center">
                        <ul class="list-inline me-auto mb-0"> 
                          <li class="list-inline-item align-bottom" data-bs-toggle="tooltip" title="Edit">
                            <a href="../sala_inversion/edit/{{ $salas_inversion->id}}" >
                             $ {{number_format($salas_inversion->valor , 0, '.', ',')}}
                            </a>
                          </li> 
                        </ul>
                      </td>
                      <td class="text-center">{{ $salas_inversion->nombre}}</td>  
                      <td class="text-center">{{ $salas_inversion->descripcion}}</td>   
                      <td class="text-center"> {{number_format($salas_inversion->porcentaje_invitacion_directa , 0, '.', ',')}} %</td>     
                      <td class="text-center"> {{number_format($salas_inversion->porcentaje_interes_compuesto , 0, '.', ',')}} %</td>     
                      <td class="text-center"> {{number_format($salas_inversion->porcentaje_sala_espera , 0, '.', ',')}} %</td>     
                      </tr>
                    @endforeach

                    </tbody> 
                  </table>
                </div>
              </div>
            </div>
          </div>
 
 </div>
</div>
</section>

          <!-- DOM/Jquery table end -->
<!--main--> 

    <!-- datatable Js --> 
 
 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="{{ URL::asset('js/plugins/jquery.dataTables.min.js')}}"></script>
    <script src="{{ URL::asset('js/plugins/dataTables.bootstrap5.min.js')}}"></script>
    <script src="{{ URL::asset('js/plugins/dataTables.responsive.min.js')}}"></script>
    <script src="{{ URL::asset('js/plugins/responsive.bootstrap5.min.js')}}"></script>

    <script>
      // [ DOM/jquery ] 
 $(document).ready(function()
            {
     // [ Configuration Option ]
      $('#table-inventory-cat').dataTable(
                {
                    responsive: false,
                    fixedHeader: true, 
                    select: 'single',
                    ordering: false, 
                    "language": {
          "info": "Mostrando del _START_ al _END_ de _TOTAL_ registros",
          "search": "Buscar",
          "zeroRecords": "No se encontraron registros",
          "lengthMenu":     "Mostrar _MENU_ registros",
          "emptyTable":     "No hay registros por mostrar",
          "paginate": {
            "previous": "Anterior",
            "next": "Siguiente",
            
          }
        },
                    dom: "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-right justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-left justify-content-end'B>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                    buttons: [
                        {
                            extend: 'colvis',
                            text: 'Column Visibility',
                            titleAttr: 'Col visibility',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'csvHtml5',
                            text: 'CSV',
                            titleAttr: 'Generate CSV',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'copyHtml5',
                            text: 'Copy',
                            titleAttr: 'Copy to clipboard',
                            className: 'btn-outline-default'
                        },
                        {
                            extend: 'print',
                            text: '<i class="fal fa-print"></i>',
                            titleAttr: 'Print Table',
                            className: 'btn-outline-default'
                        }

                    ], 

                    

                }); // FIN DE TABLA
                
    }); // FIN DE TABLA
 
    </script>

@endsection