<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FileUploadController;  
use App\Http\Controllers\HomeController;
use App\Http\Controllers\MailController;
use App\Http\Controllers\UsersController;
use App\Http\Controllers\UsersAdminController;  

use App\Http\Controllers\DisciplinasController;  
use App\Http\Controllers\CompetidoresController;  
use App\Http\Controllers\SalasInversionController;  
use App\Http\Controllers\PromocionesController;  
use App\Http\Controllers\ParametrosController;  
 

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('auth.login'); 
});

 Route::get('/reset-password/{token}', function (string $token) {
    return view('auth.reset-password', ['token' => $token]);
})->middleware('guest')->name('password.reset');


 Route::post('/logout', function () {
    Auth::logout();
    request()->session()->invalidate();
    request()->session()->regenerateToken();
    return redirect('/login');
})->name('logout');

/**********************************/  



Route::get('file-upload', [FileUploadController::class, 'index']);
Route::post('store', [FileUploadController::class, 'store']);

// MAIL

// email send
Route::get ('/mailform',[MailController::class,'mailform'])->name('mailform');
Route::post ('/send-mail',[MailController::class,'maildata'])->name('send_mail');


/***************************/

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {

/*********  DASHBOARD **************/  


Route::get('/dashboard', [HomeController::class, 'index'])->name('dashboard');
Route::get('/dashboard_projects', [HomeProjectsController::class, 'index'])->name('dashboard_projects');  

}); 

/********* USERSS ADMIN**********/ 


Route::get('/user', [UsersController::class, 'Listusers'])->name('user');
Route::get('/user_add', [UsersController::class, 'Addusers'])->name('user_add');
Route::post('/user_save', [UsersController::class, 'Saveusers'])->name('user_save');
Route::get('/user_edit/{socio_id}', [UsersController::class, 'Editusers'])->name('user_edit/{user_id}');
Route::post('/user_update', [UsersController::class, 'Updateuser'])->name('user_update');
Route::get('/user_delete/{socio_id}', [UsersController::class, 'Destroyuser'])->middleware('auth')->name('user_delete');

/********* USERSS **********/ 


Route::get('/user_admin', [UsersAdminController::class, 'ListAdminusers'])->name('user_admin');
Route::get('/user_admin_add', [UsersAdminController::class, 'AddAdminusers'])->name('user_admin_add');
Route::post('/user_admin_save', [UsersAdminController::class, 'SaveAdminusers'])->name('user_admin_save');
Route::get('/user_admin_edit/{socio_id}', [UsersAdminController::class, 'EditAdminusers'])->name('user_admin_edit/{user_id}');
Route::post('/user_admin_update', [UsersAdminController::class, 'UpdateAdminuser'])->name('user_admin_update');
Route::get('/user_admin_delete/{socio_id}', [UsersAdminController::class, 'DestroyAdminuser'])->middleware('auth')->name('user_admin_delete');

Route::post('/update_status_user', [UsersAdminController::class, 'Statususer'])->middleware('auth')->name('update_status_user'); 



/********* SALAS DE INVERSIÓN **********/ 
 
Route::get('/salas_inversion/list', [SalasInversionController::class, 'Listsalasinversion'])->middleware('auth')->name('salas_inversion/list');
Route::get('/sala_inversion/add', [SalasInversionController::class, 'Addsalasinversion'])->middleware('auth')->name('sala_inversion/add');
Route::post('/sala_inversion/save', [SalasInversionController::class, 'Savesalasinversion'])->middleware('auth')->name('sala_inversion/save');
Route::get('/sala_inversion/edit/{salas_inversion_id}', [SalasInversionController::class, 'Editsalasinversion'])->middleware('auth')->name('sala_inversion/edit/{disciplina_id}');
Route::post('/sala_inversion/update', [SalasInversionController::class, 'Updatesalasinversion'])->middleware('auth')->name('sala_inversion/update');
Route::get('/sala_inversion/destroy/{salas_inversion_id}', [SalasInversionController::class, 'Deletesalasinversion'])->middleware('auth')->name('sala_inversion/destroy/{disciplina_id}');


/********* PROMOCIONES **********/ 

 Route::post('/promocion/store_file_promocion_detalle', [PromocionesController::class, 'store_file_promocion_detalle'])->middleware('auth')->name('promocion/store_file_promocion_detalle');

Route::post('/promocion/update', [PromocionesController::class, 'UpdatePromociones'])->middleware('auth')->name('promocion/update');

Route::post('/promocion/delete_promocion', [PromocionesController::class, 'delete_promocion'])->middleware('auth')->name('promocion/delete_promocion');
 


/********* PARÁMETROS **********/ 

 
Route::get('/parametros_edit', [ParametrosController::class, 'Editparametros'])->middleware('auth')->name('parametros_edit');
Route::post('/parametros_update', [ParametrosController::class, 'Updateparametros'])->name('parametros_update');


/********* USERSS ADMIN**********/ 


Route::get('/cuentas_por_validar', [UsersController::class, 'ListCuentasValidar'])->name('cuentas_por_validar');
Route::get('/cuentas_activas', [UsersController::class, 'ListCuentasActivas'])->name('cuentas_activas');
Route::get('/cuentas_rechazadas', [UsersController::class, 'ListCuentasRechazadas'])->name('cuentas_rechazadas');
Route::get('/usuarios_sin_cuenta', [UsersController::class, 'ListSinCuenta'])->name('usuarios_sin_cuenta');


/****** VALIDACIÓN DE CUENTAS ****/	

Route::post('/validar_cuenta_user', [UsersAdminController::class, 'ValidarCuenta'])->middleware('auth')->name('validar_cuenta_user'); 

Route::post('/validar_pago_user', [UsersAdminController::class, 'ValidarPago'])->middleware('auth')->name('validar_pago_user'); 
Route::get('/exportar_txt', [UsersAdminController::class, 'exportarTxt'])->middleware('auth')->name('exportar_txt'); 
Route::get('/aplicar_pago_txt', [UsersAdminController::class, 'aplicarPagoTxt'])->middleware('auth')->name('aplicar_pago_txt'); 
 
/****** NUEVA CAPITALIZACIÓN ***************/

Route::post('/crear_inversion', [UsersController::class, 'Crearinversion'])->middleware('auth')->name('crear_inversion'); 
