<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <!-- Title -->
    <title>Las Barricas </title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="DexignZone">
    <meta name="robots" content="">

    <meta name="keywords" content=" admin dashboard, admin template, administration, analytics, bootstrap, cafe admin, elegant, food, health, kitchen, modern, responsive admin dashboard, restaurant dashboard">
    <meta name="description" content="Boost your Restaurant business with Uena Bootstrap 5 HTML Dashboard Template. Our professionally designed admin templates cater specifically to the needs of Food, admin and cafe business, offering visually stunning and functional designs. Choose from a variety of Uena website templates that are perfect for showcasing your menu, promoting your services, and attracting Factory  customers. Partner with DexignZone to create an impressive online presence for your Restaurant. Start driving more traffic and growing your business today">

    <meta property="og:title" content="Uena - Restaurant Admin Dashboard">
    <meta property="og:description" content="Boost your Restaurant business with Uena Bootstrap 5 HTML Dashboard Template. Our professionally designed admin templates cater specifically to the needs of Food, admin and cafe business, offering visually stunning and functional designs. Choose from a variety of Uena website templates that are perfect for showcasing your menu, promoting your services, and attracting Factory  customers. Partner with DexignZone to create an impressive online presence for your Restaurant. Start driving more traffic and growing your business today">
    <meta property="og:image" content="https://uena.dexignzone.com/xhtml/social-image.png">
    <meta name="format-detection" content="telephone=no">

    <!-- Mobile Specific -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="images/favicon.png">
    <link href="vendor/sweetalert2/dist/sweetalert2.min.css" rel="stylesheet">
    <link href="vendor/bootstrap-select/dist/css/bootstrap-select.min.css" rel="stylesheet">
    <link class="main-css" href="css/style.css" rel="stylesheet">

</head>

<body>
    <div class="authincation d-flex flex-column flex-lg-row flex-column-fluid"  style="background-color: #301F6B">
        <div class="login-aside text-center  d-flex flex-column flex-row-auto" >
            <div class="d-flex flex-column-auto flex-column pt-lg-40 pt-15">
                <div class="text-center mb-4 pt-5">
                    <img src="images/logo-full.jpeg" alt="/">  
                </div>
                <h3 class="mb-2">Dashboard</h3>
                <p>Las Barricas<br></p>
            </div>
            <div class="aside-image" style="background-image:url(images/background/pic1.svg);" ></div>
        </div>
        <div class="container flex-row-fluid d-flex flex-column justify-content-center position-relative overflow-hidden p-7 mx-auto">
            <div class="d-flex justify-content-center h-100 align-items-center">
                <div class="authincation-content style-2">
                    <div class="row no-gutters">
                        <div class="col-xl-12 tab-content"> 
                        <form method="POST" action="<?php echo e(route('login')); ?>">
                        <?php echo csrf_field(); ?>
                                <h3 class="text-center mb-4 text-white">Ingrese con su email</h3>
                                <div class="form-group mb-3">
                                    <label class="mb-1 form-label text-white">Email</label>
                                    <div>
                                        <input type="text" class="form-control" id="email" name="email" value="web_admin@lasbarricas.com" placeholder="Ingrese su email.."  >
                                    </div>
                                </div> 
                                <div class="form-group mb-3">
                                    <label class="mb-1 form-label text-white">Password</label>
                                    <div class="position-relative">
                                        <input type="password" id="password" name="password"  value="usuario4"  class="form-control" >
                                        <span class="show-pass eye">
                                            <i class="fa fa-eye-slash"></i>
                                            <i class="fa fa-eye"></i>
                                        </span>
                                    </div>
                                </div>
                                <div class="text-center mt-4">                                              
                                    <button type="submit" class="btn btn-primary btn-block" style="color:#301F6B ; background-color: #F6C800"><?php echo e(__('Log in')); ?></button>
                                </div>
                            </form>
                            <div class="new-account mt-3">
                               <?php if(Route::has('password.request')): ?>
                                    <a class="underline text-sm text-white hover:text-gray " href="<?php echo e(route('password.request')); ?>">
                                        <?php echo e(__('¿Olvidaste tu password?')); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<!--**********************************
    Scripts
***********************************-->
    <!-- Required vendors -->
    <script src="vendor/global/global.min.js"></script>
    <script src="vendor/bootstrap-select/dist/js/bootstrap-select.min.js"></script>
    <script src="js/custom.min.js"></script>
    <!-- Jquery Validation -->
    <script src="vendor/jquery-validation/jquery.validate.min.js"></script>
    
    <script src="js/login-form.js"></script>
    <script src="js/deznav-init.js"></script>
    
    
</body>
</html><?php /**PATH C:\xampp\htdocs\lasbarricas\resources\views/auth/login.blade.php ENDPATH**/ ?>