# Release Notes

## [Unreleased](https://github.com/laravel/jetstream/compare/v4.0.2...4.x)

## [v4.0.2](https://github.com/laravel/jetstream/compare/v4.0.1...v4.0.2) - 2023-09-19

- Prevent calling Inertia before it's installed by [@jrd-lewis](https://github.com/jrd-lewis) in https://github.com/laravel/jetstream/pull/1376

## [v4.0.1](https://github.com/laravel/jetstream/compare/v4.0.0...v4.0.1) - 2023-08-27

- Replace `array_merge` with spread operator in `HandleInertiaRequests` by [@osbre](https://github.com/osbre) in https://github.com/laravel/jetstream/pull/1370

## [v4.0.0](https://github.com/laravel/jetstream/compare/v3.3.3...v4.0.0) - 2023-08-24

- Livewire `v3.x` support in https://github.com/laravel/jetstream/pull/1360

## [v3.3.3](https://github.com/laravel/jetstream/compare/v3.3.2...v3.3.3) - 2023-08-23

- Fix memory leak and potential caching issue in https://github.com/laravel/jetstream/pull/1366

## [v3.3.2](https://github.com/laravel/jetstream/compare/v3.3.1...v3.3.2) - 2023-08-21

- Remove redundant v-if from menu by [@itbm](https://github.com/itbm) in https://github.com/laravel/jetstream/pull/1362

## [v3.3.1](https://github.com/laravel/jetstream/compare/v3.3.0...v3.3.1) - 2023-08-14

- Improves Jetstream model factories by [@nunomaduro](https://github.com/nunomaduro) in https://github.com/laravel/jetstream/pull/1356
- Make recovery code light when it on dark mode by [@irsyadadl](https://github.com/irsyadadl) in https://github.com/laravel/jetstream/pull/1355
- Fix the banner not showing again after dismissed by the user if the next message contents are the same by [@tomsb](https://github.com/tomsb) in https://github.com/laravel/jetstream/pull/1352

## [v3.3.0](https://github.com/laravel/jetstream/compare/v3.2.5...v3.3.0) - 2023-08-08

- [3.x] Remove unnecessary Ziggy parameter which causes ESLint errors by [@Smef](https://github.com/Smef) in https://github.com/laravel/jetstream/pull/1347
- [3.x] Use available `ServiceProvider::callAfterResolving()` by [@crynobone](https://github.com/crynobone) in https://github.com/laravel/jetstream/pull/1350
- [3.x] Laravel Pint fixes by [@iruoy](https://github.com/iruoy) in https://github.com/laravel/jetstream/pull/1351
- [3.x] Prompts by [@jessarcher](https://github.com/jessarcher) in https://github.com/laravel/jetstream/pull/1337
- [3.x] Pest detection by [@jessarcher](https://github.com/jessarcher) in https://github.com/laravel/jetstream/pull/1353

## [v3.2.5](https://github.com/laravel/jetstream/compare/v3.2.4...v3.2.5) - 2023-07-13

- Update HandleInertiaRequests.php with nullable return type by [@iamcarlos94](https://github.com/iamcarlos94) in https://github.com/laravel/jetstream/pull/1343

## [v3.2.4](https://github.com/laravel/jetstream/compare/v3.2.3...v3.2.4) - 2023-07-08

- Use appName directly from .env in <title> by [@domnantas](https://github.com/domnantas) in https://github.com/laravel/jetstream/pull/1329
- set email as required in input for UpdateUserProfileInformation by [@ordago](https://github.com/ordago) in https://github.com/laravel/jetstream/pull/1303

## [v3.2.3](https://github.com/laravel/jetstream/compare/v3.2.2...v3.2.3) - 2023-06-07

- Fix ShareInertiaData middleware for Eloquent strict mode when 2FA is disabled by @onlime in https://github.com/laravel/jetstream/pull/1319

## [v3.2.2](https://github.com/laravel/jetstream/compare/v3.2.1...v3.2.2) - 2023-05-30

- jsconfig.json configuration file by @aknEvrnky in https://github.com/laravel/jetstream/pull/1317

## [v3.2.1](https://github.com/laravel/jetstream/compare/v3.2.0...v3.2.1) - 2023-05-17

- Fix gate check when updating user permissions on a team by @drewrawitz in https://github.com/laravel/jetstream/pull/1316

## [v3.2.0](https://github.com/laravel/jetstream/compare/v3.1.3...v3.2.0) - 2023-05-10

- Migrate to modules by @timacdonald in https://github.com/laravel/jetstream/pull/1315

## [v3.1.3](https://github.com/laravel/jetstream/compare/v3.1.2...v3.1.3) - 2023-05-09

- Update two-factor-authentication-form.blade.php by @vivante64 in https://github.com/laravel/jetstream/pull/1305
- Add object-cover class to team member profile photo by @anamarijapapic in https://github.com/laravel/jetstream/pull/1304
- Update Welcome.vue by @aymanatmeh in https://github.com/laravel/jetstream/pull/1302
- Ensure email is included in state by @antja0 in https://github.com/laravel/jetstream/pull/1312
- Lint stub files with Pint by @driesvints in https://github.com/laravel/jetstream/pull/1313

## [v3.1.2](https://github.com/laravel/jetstream/compare/v3.1.1...v3.1.2) - 2023-04-21

- Remove unused imports by @akunbeben in https://github.com/laravel/jetstream/pull/1297
- Do not install auth service provider by @taylorotwell in https://github.com/laravel/jetstream/commit/dfac46f3ff3ba9a3866ac343d6aee1cc398ff0b4

## [v3.1.1](https://github.com/laravel/jetstream/compare/v3.1.0...v3.1.1) - 2023-04-10

- Fix issue with page reload/refresh on two-factor-challenge page by @andrewdwallo in https://github.com/laravel/jetstream/pull/1291
- Remove `v-show` directive from "user profile information form" template by @ndresx in https://github.com/laravel/jetstream/pull/1292
- Only show "Change Teams" options if multiple teams are available by @briankiewel in https://github.com/laravel/jetstream/pull/1294

## [v3.1.0](https://github.com/laravel/jetstream/compare/v3.0.2...v3.1.0) - 2023-03-20

- Use Pest 2 by @nunomaduro in https://github.com/laravel/jetstream/pull/1280
- Fixes typo from userPage to usePage by @john-shipp in https://github.com/laravel/jetstream/pull/1277
- Allow modification of the personal team using an optional callable by @peterfox in https://github.com/laravel/jetstream/pull/1278
- Get fresh user instance on two factor authentication tests by @telkins in https://github.com/laravel/jetstream/pull/1281

## [v3.0.2](https://github.com/laravel/jetstream/compare/v3.0.1...v3.0.2) - 2023-03-01

- Removes `@return $this` when returning static by @nunomaduro in https://github.com/laravel/jetstream/pull/1268
- Use route helper in two factor authentication form by @sushantaryal in https://github.com/laravel/jetstream/pull/1276

## [v3.0.1](https://github.com/laravel/jetstream/compare/v3.0.0...v3.0.1) - 2023-02-15

- Fixes incorrect classes for Laracasts link on Welcome.vue component by @AaronLil in https://github.com/laravel/jetstream/pull/1252
- Removed loadViewsFrom by @sirikkoster in https://github.com/laravel/jetstream/pull/1259

## [v3.0.0](https://github.com/laravel/jetstream/compare/v2.16.2...v3.0.0) - 2023-02-14

### Added

- Dark Mode by @fotrino in https://github.com/laravel/jetstream/pull/1234
- New welcome by @jessarcher in https://github.com/laravel/jetstream/pull/1247

### Changed

- Use custom TeamInvitation model in TeamInvitationController by @ManuelLeiner in https://github.com/laravel/jetstream/pull/897
- Adding Storage Path support to the HasProfilePhoto Trait by @baminc in https://github.com/laravel/jetstream/pull/999
- Change $page.user to $page.auth.user by @SamuelMwangiW in https://github.com/laravel/jetstream/pull/1073
- Copy Blade files on installation by @jessarcher in https://github.com/laravel/jetstream/pull/1118
- Type Error in PHPdoc by @marvinrabe in https://github.com/laravel/jetstream/pull/1235
- Convert Profile Photo URL attribute to newer syntax by @jrd-lewis in https://github.com/laravel/jetstream/pull/1237

## [v2.16.2](https://github.com/laravel/jetstream/compare/v2.16.1...v2.16.2) - 2023-02-14

### Fixed

- Fixes Laravel 10 `--pest` installation by @nunomaduro in https://github.com/laravel/jetstream/pull/1246

## [v2.16.1](https://github.com/laravel/jetstream/compare/v2.16.0...v2.16.1) - 2023-02-03

### Fixed

- Fix typo by @nhedger in https://github.com/laravel/jetstream/pull/1230
- Fixed not redirecting after deleting the user by @JakyeRU in https://github.com/laravel/jetstream/pull/1236
- Use autocomplete for all fields for password manager compatibility by @lukearmstrong in https://github.com/laravel/jetstream/pull/1239
- Fixes Pest stubs files by @nunomaduro in https://github.com/laravel/jetstream/pull/1240

## [v2.16.0](https://github.com/laravel/jetstream/compare/v2.15.0...v2.16.0) - 2023-01-18

### Changed

- Reverted dark mode support in https://github.com/laravel/jetstream/pull/1228

## [v2.15.0](https://github.com/laravel/jetstream/compare/v2.14.1...v2.15.0) - 2023-01-18

### Added

- Laravel v10 Support by @driesvints in https://github.com/laravel/jetstream/pull/1216
- Opt-in dark mode support by @fotrino in https://github.com/laravel/jetstream/pull/1209
- Inertia v1 by @jessarcher in https://github.com/laravel/jetstream/pull/1219

## [v2.14.1](https://github.com/laravel/jetstream/compare/v2.14.0...v2.14.1) - 2023-01-10

### Fixed

- Fixes publishing jetstream-inertia-auth-pages, that was referencing an old stub path by @juse-less in https://github.com/laravel/jetstream/pull/1210
- Prevent `MissingAttributeException` by @jessarcher in https://github.com/laravel/jetstream/pull/1213

## [v2.14.0](https://github.com/laravel/jetstream/compare/v2.13.1...v2.14.0) - 2023-01-03

### Changed

- Update to Heroicons v2 by @driesvints in https://github.com/laravel/jetstream/pull/1200
- Uses PHP Native Type Declarations 🐘  by @nunomaduro in https://github.com/laravel/jetstream/pull/1175

### Fixed

- Add focus styling for settings dropdown trigger button by @thema-d in https://github.com/laravel/jetstream/pull/1206
- Fix the order of the v-if attribute. by @milorojas in https://github.com/laravel/jetstream/pull/1208

## [v2.13.1](https://github.com/laravel/jetstream/compare/v2.13.0...v2.13.1) - 2022-12-16

### Fixed

- Fixed and issue causing overflow in ApiTokenManager page on mobile devices. by @ravibpatel in https://github.com/laravel/jetstream/pull/1198

## [v2.13.0](https://github.com/laravel/jetstream/compare/v2.12.6...v2.13.0) - 2022-12-16

### Added

- Vite 4 support by @timacdonald in https://github.com/laravel/jetstream/pull/1193

### Changed

- Redirect to the fortify configured logout redirect after deleting user by @riasvdv in https://github.com/laravel/jetstream/pull/1191

## [v2.12.6](https://github.com/laravel/jetstream/compare/v2.12.5...v2.12.6) - 2022-12-05

### Changed

- Use x-Focus Alpine JS plugin for Livewire stack modal by @x7ryan in https://github.com/laravel/jetstream/pull/1186
- Use Default NPM Package Manager of User if Lock File Exists In Base Path by @andrewdwallo in https://github.com/laravel/jetstream/pull/1187

## [v2.12.5](https://github.com/laravel/jetstream/compare/v2.12.4...v2.12.5) - 2022-10-26

### Fixed

- Fix dev preloading by @timacdonald in https://github.com/laravel/jetstream/pull/1171

## [v2.12.4](https://github.com/laravel/jetstream/compare/v2.12.3...v2.12.4) - 2022-10-25

### Changed

- Register: add required to terms checkbox by @A-w-x in https://github.com/laravel/jetstream/pull/1158
- Added missing localization in logout-other-browser-sessions-form.blade.php by @JakyeRU in https://github.com/laravel/jetstream/pull/1163
- Vite preloading by @timacdonald in https://github.com/laravel/jetstream/pull/1169

## [v2.12.3](https://github.com/laravel/jetstream/compare/v2.12.2...v2.12.3) - 2022-09-26

### Changed

- Pass additional props to the teams create view. by @clcarver in https://github.com/laravel/jetstream/pull/1149

## [v2.12.2](https://github.com/laravel/jetstream/compare/v2.12.1...v2.12.2) - 2022-09-15

### Fixed

- Fix test by @driesvints in https://github.com/laravel/jetstream/pull/1138

## [v2.12.1](https://github.com/laravel/jetstream/compare/v2.12.0...v2.12.1) - 2022-09-12

### Changed

- Call `storage:link` on install by @jessarcher in https://github.com/laravel/jetstream/pull/1133
- Remove redundant remove-member link by @devnll in https://github.com/laravel/jetstream/pull/1135

## [v2.12.0](https://github.com/laravel/jetstream/compare/v2.11.2...v2.12.0) - 2022-09-06

### Changed

- Remove "Jet" component prefix by @jessarcher in https://github.com/laravel/jetstream/pull/1117

## [v2.11.2](https://github.com/laravel/jetstream/compare/v2.11.1...v2.11.2) - 2022-08-22

### Changed

- Check current model supports HasTeams before trying to access team information. by @crynobone in https://github.com/laravel/jetstream/pull/1120
- Update Register.vue by @JoshSalway in https://github.com/laravel/jetstream/pull/1127

## [v2.11.1](https://github.com/laravel/jetstream/compare/v2.11.0...v2.11.1) - 2022-08-17

### Changed

- Style improvements by @jessarcher in https://github.com/laravel/jetstream/pull/1116
- Install NPM dependencies and build assets by @jessarcher in https://github.com/laravel/jetstream/pull/1119
- Update inertiajs/inertia-laravel to ^0.6.3 by @ashleyshenton in https://github.com/laravel/jetstream/pull/1122
- Display validation errors alongside fields in the Inertia stack by @jessarcher in https://github.com/laravel/jetstream/pull/1123

> > > > > > > 2.x

## [v2.11.0](https://github.com/laravel/jetstream/compare/v2.10.3...v2.11.0) - 2022-08-08

### Changed

- Update install command output to display vite build command by @RhysLees in https://github.com/laravel/jetstream/pull/1109
- Validate the stack argument by @jessarcher in https://github.com/laravel/jetstream/pull/1113
- Move Jetstream components to Components directory by @jessarcher in https://github.com/laravel/jetstream/pull/1110

## [v2.10.3](https://github.com/laravel/jetstream/compare/v2.10.2...v2.10.3) - 2022-08-01

### Changed

- Switch to fonts.bunny.net instead of Google Fonts by @lucasRolff in https://github.com/laravel/jetstream/pull/1104

## [v2.10.2](https://github.com/laravel/jetstream/compare/v2.10.1...v2.10.2) - 2022-07-21

### Changed

- Change position of Livewire Style by @syntafin in https://github.com/laravel/jetstream/pull/1093
- Skip two factor authentication tests when the feature is disabled by @mbabker in https://github.com/laravel/jetstream/pull/1095
- Improves console output by @nunomaduro in https://github.com/laravel/jetstream/pull/1097

## [v2.10.1](https://github.com/laravel/jetstream/compare/v2.10.0...v2.10.1) - 2022-07-20

### Changed

- Vite 3 support by @timacdonald in https://github.com/laravel/jetstream/pull/1089

## [v2.10.0](https://github.com/laravel/jetstream/compare/v2.9.0...v2.10.0) - 2022-07-11

### Changed

- Add default view / routes reloading to jetstream stacks by @timacdonald in https://github.com/laravel/jetstream/pull/1080
- Update SSR directory by @jessarcher in https://github.com/laravel/jetstream/pull/1084
- Add livewire component paths to default refresh paths for livewire stack by @timacdonald in https://github.com/laravel/jetstream/pull/1081

### Removed

- Drop Laravel 8.x support (and PHP < 8) by @timacdonald in https://github.com/laravel/jetstream/pull/1082

## [v2.9.0](https://github.com/laravel/jetstream/compare/v2.8.5...v2.9.0) - 2022-06-28

### Added

- Vite by @jessarcher in https://github.com/laravel/jetstream/pull/1068

### Fixed

- Fix TailwindCSS first party TypeScript types weren't working right by @geisi in https://github.com/laravel/jetstream/pull/1074
- Bump @tailwindcss/forms by @timacdonald in https://github.com/laravel/jetstream/pull/1076
- Fix ziggy location instead of base url by @matthieumota in https://github.com/laravel/jetstream/pull/1078

## [v2.8.5](https://github.com/laravel/jetstream/compare/v2.8.4...v2.8.5) - 2022-06-16

### Changed

- Add .vue extension to imports by @SamuelMwangiW in https://github.com/laravel/jetstream/pull/1067
- Bump TailwindCSS to 3.1 by @geisi in https://github.com/laravel/jetstream/pull/1066

### Fixed

- Fix Inertia SSR usage with Ziggy route function in setup() by @prestonholt in https://github.com/laravel/jetstream/pull/1069

## [v2.8.4](https://github.com/laravel/jetstream/compare/v2.8.3...v2.8.4) - 2022-06-01

### Changed

- Skip tests for team invitations if disabled by @jradtilbrook in https://github.com/laravel/jetstream/pull/1063
- Display available stack options by @jessarcher in https://github.com/laravel/jetstream/pull/1062

## [v2.8.3](https://github.com/laravel/jetstream/compare/v2.8.2...v2.8.3) - 2022-05-30

### Changed

- Switch to ESM imports by @jessarcher in https://github.com/laravel/jetstream/pull/1059
- Bump tailwindcss/forms to 0.5.0 by @driesvints in https://github.com/laravel/jetstream/pull/1061
- Simplify Tailwind installation by @jessarcher in https://github.com/laravel/jetstream/pull/1060

## [v2.8.2](https://github.com/laravel/jetstream/compare/v2.8.1...v2.8.2) - 2022-05-24

### Fixed

- Fixed an issue causing warning when clicking on Manage Permissions or Delete on created token. by @ravibpatel in https://github.com/laravel/jetstream/pull/1056

## [v2.8.1](https://github.com/laravel/jetstream/compare/v2.8.0...v2.8.1) - 2022-05-13

### Fixed

- Fix disabled email verification mode by @driesvints in https://github.com/laravel/jetstream/pull/1053

## [v2.8.0](https://github.com/laravel/jetstream/compare/v2.7.5...v2.8.0) - 2022-05-10

### Added

- Verification improvements by @driesvints in https://github.com/laravel/jetstream/pull/1048

## [v2.7.5](https://github.com/laravel/jetstream/compare/v2.7.4...v2.7.5) - 2022-04-25

### Fixed

- Fix banner not showing again if dismissed by the user by @LucaRed in https://github.com/laravel/jetstream/pull/1045

## [v2.7.4](https://github.com/laravel/jetstream/compare/v2.7.3...v2.7.4) - 2022-04-19

### Changed

- Install pest as devDependency by @abenerd in https://github.com/laravel/jetstream/pull/1040

## [v2.7.3](https://github.com/laravel/jetstream/compare/v2.7.2...v2.7.3) - 2022-04-08

### Fixed

- Fix parse error caused by alpine shorthand on dynamic-component by @authanram in https://github.com/laravel/jetstream/pull/1032
- Fix error handling during 2FA confirmation by @ManuelLeiner in https://github.com/laravel/jetstream/pull/1030
- Fix if user logs out when viewing the 2FA Form by @jjhamkuijpers in https://github.com/laravel/jetstream/pull/1034

## [v2.7.2](https://github.com/laravel/jetstream/compare/v2.7.1...v2.7.2) - 2022-04-03

### Fixed

- Use Alpine's @click.prevent for switching teams by @jrd-lewis in https://github.com/laravel/jetstream/pull/1027

## [v2.7.1](https://github.com/laravel/jetstream/compare/v2.7.0...v2.7.1) - 2022-03-30

### Fixed

- Not require `Ziggy` on `ShareInertiaData` middleware. by @xiCO2k in https://github.com/laravel/jetstream/pull/1024

## [v2.7.0](https://github.com/laravel/jetstream/compare/v2.6.8...v2.7.0) - 2022-03-29

### Added

- Confirm 2FA when enabling by @driesvints & @taylorotwell in https://github.com/laravel/jetstream/pull/992
- 2FA Setup Key by @ps-sean in https://github.com/laravel/jetstream/pull/1008
- Add Inertia SSR Support by @xiCO2k in https://github.com/laravel/jetstream/pull/1012

### Changed

- Match Inertia Scaffolding with Livewire in regards to AuthenticateSessions by @taylorotwell in https://github.com/laravel/jetstream/pull/1003
- Change Inertia Stubs to Composition API by @xiCO2k in https://github.com/laravel/jetstream/pull/1001
- Remove return in ensurePasswordIsConfirmed by @driesvints in https://github.com/laravel/jetstream/pull/1006
- Use `.alias` method from `Mix` by @xiCO2k in https://github.com/laravel/jetstream/pull/1009

### Fixed

- Fix stub tests by @driesvints in https://github.com/laravel/jetstream/pull/1014
- Prioritize 'accepted' validation rule for terms checkbox in CreateNewUserWithTeams.php by @ChrisRiddell in https://github.com/laravel/jetstream/pull/1019

## [v2.6.8](https://github.com/laravel/jetstream/compare/v2.6.7...v2.6.8) - 2022-03-15

### Fixed

- First check for ownership by @rennokki in https://github.com/laravel/jetstream/pull/996

## [v2.6.7](https://github.com/laravel/jetstream/compare/v2.6.6...v2.6.7) - 2022-03-03

### Changed

- HasTeams.php: make belongsToTeam accept null team by @cholladay0816 in https://github.com/laravel/jetstream/pull/986
- Use Alpine's @click.prevent for log out by @jrd-lewis in https://github.com/laravel/jetstream/pull/989

## [v2.6.6](https://github.com/laravel/jetstream/compare/v2.6.5...v2.6.6) - 2022-02-15

### Fixed

- Install command find the path to the php binary used ([#976](https://github.com/laravel/jetstream/pull/976))
- Priorize 'accepted' validation rule for terms checkbox ([#980](https://github.com/laravel/jetstream/pull/980))
- Mail Faker need on test cancelled invitations ([#978](https://github.com/laravel/jetstream/pull/978), [a03b8ec](https://github.com/laravel/jetstream/commit/a03b8ececef21e4d2c3bfb8a7e90ec36c2dfaaf9))

## [v2.6.5](https://github.com/laravel/jetstream/compare/v2.6.4...v2.6.5) - 2022-02-08

### Fixed

- Fixed avatar multibyte character issue ([#973](https://github.com/laravel/jetstream/pull/973))

## [v2.6.4 (2022-02-01)](https://github.com/laravel/jetstream/compare/v2.6.3...v2.6.4)

### Changed

- Fix PHP 8.1 return type ([#969](https://github.com/laravel/jetstream/pull/969))

## [v2.6.3 (2022-01-25)](https://github.com/laravel/jetstream/compare/v2.6.2...v2.6.3)

### Changed

- Switch to Laravel 8.37 >= anonymous migrations ([#961](https://github.com/laravel/jetstream/pull/961))

### Fixed

- Add Check before deleting a profile photo ([#959](https://github.com/laravel/jetstream/pull/959))
- Always return array to ui from allTeams() ([#966](https://github.com/laravel/jetstream/pull/966))

## [v2.6.2 (2022-01-18)](https://github.com/laravel/jetstream/compare/v2.6.1...v2.6.2)

### Changed

- Route group Sanctum guard ([#957](https://github.com/laravel/jetstream/pull/957))
- Add config option for guard ([82724e7](https://github.com/laravel/jetstream/commit/82724e7d7053fbaed82fcd9f196cdea4f1ca311f))
- Make config stub and set default guard ([fff4df4](https://github.com/laravel/jetstream/commit/fff4df4dbe2ab9aa03ecd8f0120399b91ec6aef9))

## [v2.6.1 (2022-01-13)](https://github.com/laravel/jetstream/compare/v2.6.0...v2.6.1)

### Changed

- Bump `inertiajs/inertia-laravel` ([#954](https://github.com/laravel/jetstream/pull/954))

## [v2.6.0 (2022-01-12)](https://github.com/laravel/jetstream/compare/v2.5.1...v2.6.0)

### Changed

- Laravel 9 Support ([#948](https://github.com/laravel/jetstream/pull/948))
- Anonymize default profile photo url calls ([#940](https://github.com/laravel/jetstream/pull/940))

## [v2.5.1 (2022-01-04)](https://github.com/laravel/jetstream/compare/v2.5.0...v2.5.1)

### Changed

- Fixed a content reflow issue on slower connection in update profile info form ([#929](https://github.com/laravel/jetstream/pull/929))
- Fixed a button spacing issue in dialog modal footer ([#930](https://github.com/laravel/jetstream/pull/930), [#935](https://github.com/laravel/jetstream/pull/935))
- Show 'Unknown' instead of 'false' if other browser session Useragent details are not matched in library ([#934](https://github.com/laravel/jetstream/pull/934))

## [v2.5.0 (2021-12-14)](https://github.com/laravel/jetstream/compare/v2.4.4...v2.5.0)

### Changed

- Update to Tailwind CSS v3 ([#920](https://github.com/laravel/jetstream/pull/920), [#926](https://github.com/laravel/jetstream/pull/926))
- Use KeyboardEvent key attribute for Escape ([#911](https://github.com/laravel/jetstream/pull/911))

## [v2.4.4 (2021-11-02)](https://github.com/laravel/jetstream/compare/v2.4.3...v2.4.4)

### Changed

- Better handle situations where a user's role on a team is undefined ([#905](https://github.com/laravel/jetstream/pull/905))

## [v2.4.3 (2021-10-12)](https://github.com/laravel/jetstream/compare/v2.4.2...v2.4.3)

### Changed

- Merge action-section attributes ([#898](https://github.com/laravel/jetstream/pull/898))

## [v2.4.2 (2021-09-30)](https://github.com/laravel/jetstream/compare/v2.4.1...v2.4.2)

### Fixed

- Revert "Use custom TeamInvitation model in TeamInvitationController" ([#895](https://github.com/laravel/jetstream/pull/895))

## [v2.4.1 (2021-09-28)](https://github.com/laravel/jetstream/compare/v2.4.0...v2.4.1)

### Fixed

- Use custom `TeamInvitation` model in `TeamInvitationController` ([#892](https://github.com/laravel/jetstream/pull/892))

## [v2.4.0 (2021-09-14)](https://github.com/laravel/jetstream/compare/v2.3.16...v2.4.0)

### Added

- Pest support ([#866](https://github.com/laravel/jetstream/pull/866))

### Changed

- Remove `csrf_token` from meta in Inertia app ([#878](https://github.com/laravel/jetstream/pull/878))

### Fixed

- Use correct feature flag in password reset tests ([#881](https://github.com/laravel/jetstream/pull/881))

## [v2.3.16 (2021-08-31)](https://github.com/laravel/jetstream/compare/v2.3.15...v2.3.16)

### Changed

- Use defineComponent in vue stubs for easier typescript setup ([#869](https://github.com/laravel/jetstream/pull/869))

### Fixed

- Added "text-left" class to team role descriptions ([#865](https://github.com/laravel/jetstream/pull/865))

## [v2.3.15 (2021-08-17)](https://github.com/laravel/jetstream/compare/v2.3.14...v2.3.15)

### Changed

- Remove unused dependency from `composer.json` ([#846](https://github.com/laravel/jetstream/pull/846))
- Make string constants a translation strings ([#851](https://github.com/laravel/jetstream/pull/851))
- Update banner component svg icon ([#857](https://github.com/laravel/jetstream/pull/857))

### Removed

- Remove unneeded tailwind config variant definitions ([#853](https://github.com/laravel/jetstream/pull/853))

## [v2.3.14 (2021-07-28)](https://github.com/laravel/jetstream/compare/v2.3.13...v2.3.14)

### Fixed

- Support both CommonMark v1 & v2 ([#845](https://github.com/laravel/jetstream/pull/845))

## [v2.3.13 (2021-07-26)](https://github.com/laravel/jetstream/compare/v2.3.12...v2.3.13)

### Fixed

- Fix key name ([b33a95d](https://github.com/laravel/jetstream/commit/b33a95dabf6ca8dc6b3c6fe3135a9645bf70095b))

## [v2.3.12 (2021-07-25)](https://github.com/laravel/jetstream/compare/v2.3.11...v2.3.12)

### Changed

- Redirect by route name ([#828](https://github.com/laravel/jetstream/pull/828))
- Add Vue file extension to all Vue components imported ([#829](https://github.com/laravel/jetstream/pull/829))
- Prepare translated roles on Livewire using `jsonSerialize()` ([#837](https://github.com/laravel/jetstream/pull/837))
- Defer to Fortify for password confirmation ([#835](https://github.com/laravel/jetstream/pull/835))

### Fixed

- Update `<Link>` tags & implement `<Head>` management ([#832](https://github.com/laravel/jetstream/pull/832))
- Fix commonmark install issue ([#840](https://github.com/laravel/jetstream/pull/840))

## [v2.3.11 (2021-06-29)](https://github.com/laravel/jetstream/compare/v2.3.10...v2.3.11)

### Changed

- Add ability to focus first modal element on opening ([#814](https://github.com/laravel/jetstream/pull/814))

### Fixed

- Support both Alpine V2 and V3 ([#813](https://github.com/laravel/jetstream/pull/813))

## [v2.3.10 (2021-06-22)](https://github.com/laravel/jetstream/compare/v2.3.9...v2.3.10)

### Changed

- Upgrade Alpine from V2 to V3 ([#808](https://github.com/laravel/jetstream/pull/808))
- Enable Tailwind JIT-Mode ([#810](https://github.com/laravel/jetstream/pull/810), [#809](https://github.com/laravel/jetstream/pull/809))

## [v2.3.9 (2021-06-15)](https://github.com/laravel/jetstream/compare/v2.3.8...v2.3.9)

### Changed

- Update front-end dependencies ([#804](https://github.com/laravel/jetstream/pull/804))

## [v2.3.8 (2021-06-08)](https://github.com/laravel/jetstream/compare/v2.3.7...v2.3.8)

### Fixed

- Skip registration tests if Fortify registration is disabled ([#799](https://github.com/laravel/jetstream/pull/799))
- Remove overflow property when unmounted ([#801](https://github.com/laravel/jetstream/pull/801))

## [v2.3.7 (2021-06-01)](https://github.com/laravel/jetstream/compare/v2.3.6...v2.3.7)

### Changed

- Allow Role's `$name` and `$description` to be translated ([#798](https://github.com/laravel/jetstream/pull/798))

### Fixed

- Remove dark classes from QR Code ([#788](https://github.com/laravel/jetstream/pull/788))
- Changed the column type of profile_photo_path ([#794](https://github.com/laravel/jetstream/pull/794))
- Fix cors policy errors with inertia stack ([#797](https://github.com/laravel/jetstream/pull/797))

## [v2.3.6 (2021-05-18)](https://github.com/laravel/jetstream/compare/v2.3.5...v2.3.6)

### Fixed

- Inertia - ensure file selection is not empty before updating profile photo preview ([#782](https://github.com/laravel/jetstream/pull/782))
- Added canCreateTeams validation in responsive-nav-link of AppLayout ([#785](https://github.com/laravel/jetstream/pull/785))

## [v2.3.5 (2021-05-11)](https://github.com/laravel/jetstream/compare/v2.3.4...v2.3.5)

### Changed

- Publish `UserFactory.php` ([244150f](https://github.com/laravel/jetstream/commit/244150f145ef7ed4eb9bdeda279d9859859173b6))

### Fixes

- Check OwnsTeam for null teams ([#774](https://github.com/laravel/jetstream/pull/774))
- Inertia - clear user profile photo input ([#781](https://github.com/laravel/jetstream/pull/781))

## [v2.3.4 (2021-04-27)](https://github.com/laravel/jetstream/compare/v2.3.3...v2.3.4)

### Changed

- Update NPM dependencies ([#767](https://github.com/laravel/jetstream/pull/767))

### Fixed

- Get model of PersonalAccessToken before deleting it ([#771](https://github.com/laravel/jetstream/pull/771))
- Fix selector query ([#772](https://github.com/laravel/jetstream/pull/772))

## [v2.3.3 (2021-04-20)](https://github.com/laravel/jetstream/compare/v2.3.2...v2.3.3)

### Fixed

- Exclude hidden inputs from focusable elements ([#757](https://github.com/laravel/jetstream/pull/757))

## [v2.3.2 (2021-04-13)](https://github.com/laravel/jetstream/compare/v2.3.1...v2.3.2)

### Fixed

- Check for session before attempting to invalidate ([#750](https://github.com/laravel/jetstream/pull/750))
- Replace shadow-outline with ring ([#751](https://github.com/laravel/jetstream/pull/751))

## [v2.3.1 (2021-04-06)](https://github.com/laravel/jetstream/compare/v2.3.0...v2.3.1)

### Fixed

- Made sure that the current session is destroyed when deleting your account ([#742](https://github.com/laravel/jetstream/pull/742), [9663d7e](https://github.com/laravel/jetstream/commit/9663d7eb4e58ec86f105efb07f712fb81e6c92f2))

## [v2.3.0 (2021-03-30)](https://github.com/laravel/jetstream/compare/v2.2.5...v2.3.0)

### Added

- Add section title aside slot ([#727](https://github.com/laravel/jetstream/pull/727))

### Changed

- Remove unnecessary CSS classes ([#735](https://github.com/laravel/jetstream/pull/735))
- Accept any type of response in RedirectsActions trait ([#740](https://github.com/laravel/jetstream/pull/740))

### Fixed

- Fixed the test that's failing in EmailVerificationTest ([#737](https://github.com/laravel/jetstream/pull/737), [e0a9d2e](https://github.com/laravel/jetstream/commit/e0a9d2e4d504c88d069691ee82d803801badb641))
- Fixes an error when sending email invitations when Fortify's registration feature is turned off ([#741](https://github.com/laravel/jetstream/pull/741))

## [v2.2.5 (2021-03-25)](https://github.com/laravel/jetstream/compare/v2.2.4...v2.2.5)

### Fixed

- Revert "Reduce amount of queries for Teams feature" ([#729](https://github.com/laravel/jetstream/pull/729))

## [v2.2.4 (2021-03-23)](https://github.com/laravel/jetstream/compare/v2.2.3...v2.2.4)

### Changed

- Test team features only when active ([#698](https://github.com/laravel/jetstream/pull/698))
- Reduce amount of queries for Teams feature ([#708](https://github.com/laravel/jetstream/pull/708))
- Add a tag dropdown link ([#711](https://github.com/laravel/jetstream/pull/711))

### Fixed

- Button Disabled opacity-25 ([#712](https://github.com/laravel/jetstream/pull/712))
- Add scroll-region to modal ([#724](https://github.com/laravel/jetstream/pull/724))
- Load modal slot on show ([#723](https://github.com/laravel/jetstream/pull/723))

### Removed

- Don't require autoprefixer ([#714](https://github.com/laravel/jetstream/pull/714))

## [v2.2.3 (2021-03-02)](https://github.com/laravel/jetstream/compare/v2.2.2...v2.2.3)

### Fixed

- Update mimes ([90b6d1b](https://github.com/laravel/jetstream/commit/90b6d1b5ddb02a10f4698428e02c204962a9d16a))
- Prevent network request when pressing escape to close modal ([#695](https://github.com/laravel/jetstream/pull/695))

## [v2.2.2 (2021-02-23)](https://github.com/laravel/jetstream/compare/v2.2.1...v2.2.2)

### Changed

- Use cancel wording ([9b7dbb4e](https://github.com/laravel/jetstream/commit/9b7dbb4ea10aa7a5b678695719f7f1bc820b61ec))
- Use inertia progress ([c1f1fa0](https://github.com/laravel/jetstream/commit/c1f1fa0ab964f3b9dbe144eb60e18d38e835b195))
- Remove '.native' deprecated modifier in vue3 ([#689](https://github.com/laravel/jetstream/pull/689))

### Fixed

- Require password ([b24ef0c](https://github.com/laravel/jetstream/commit/b24ef0ceea656adc71367c1d64190626f27e8c1e))

## [v2.2.1 (2021-02-16)](https://github.com/laravel/jetstream/compare/v2.2.0...v2.2.1)

### Changed

- Add unverified state to `UserFactory` ([#679](https://github.com/laravel/jetstream/pull/679))

### Fixed

- Update purge settings ([36c4685](https://github.com/laravel/jetstream/commit/36c46858b2dfd0b6b001872ce4d682a31221bb49))

## [v2.2.0 (2021-02-16)](https://github.com/laravel/jetstream/compare/v2.1.4...v2.2.0)

### Added

- Vue v3.0 support ([#666](https://github.com/laravel/jetstream/pull/666))

### Fixed

- Fix ownsTeam when applied to non-User model ([#673](https://github.com/laravel/jetstream/pull/673))
- Allow UpdateTeamNameForm in Livewire to hydrate all Team attributes ([#676](https://github.com/laravel/jetstream/pull/676))
- Change "Logout" text to "Log out" and "Login" to "Log in" ([#677](https://github.com/laravel/jetstream/pull/677))

## [v2.1.4 (2021-02-09)](https://github.com/laravel/jetstream/compare/v2.1.3...v2.1.4)

### Changed

- Allow custom classes on the dropdown class ([#661](https://github.com/laravel/jetstream/pull/661))

### Fixed

- Fix permissions for team create routes ([#669](https://github.com/laravel/jetstream/pull/669))
- Fix overflow hidden issue with overlaping elements inside form section ([#668](https://github.com/laravel/jetstream/pull/668))

## [v2.1.3 (2021-02-02)](https://github.com/laravel/jetstream/compare/v2.1.2...v2.1.3)

### Changed

- Add `profile_photo_disk` config option ([#658](https://github.com/laravel/jetstream/pull/658), [a6245c8](https://github.com/laravel/jetstream/commit/a6245c84adc2ea209a34051ff543ccc302a275e8))

## [v2.1.2 (2021-01-26)](https://github.com/laravel/jetstream/compare/v2.1.1...v2.1.2)

### Changed

- Enabling Github Flavored Markdown for Terms and Privacy Policy ([#645](https://github.com/laravel/jetstream/pull/645))

### Fixed

- Hide AppLayout header if no slot defined in Page component ([#650](https://github.com/laravel/jetstream/pull/650), [523399f](https://github.com/laravel/jetstream/commit/523399f8496d49a6d6b6a8955b87cda0786be31b))
- Use custom team member model ([#651](https://github.com/laravel/jetstream/pull/651))
- Use email input type ([#653](https://github.com/laravel/jetstream/pull/653))

## [v2.1.1 (2021-01-19)](https://github.com/laravel/jetstream/compare/v2.1.0...v2.1.1)

### Fixed

- Fix RegistrationTest for Terms of Services ([#632](https://github.com/laravel/jetstream/pull/632))
- Add z-index to the modal ([#633](https://github.com/laravel/jetstream/pull/633))
- Skip DeleteAccountTest if feature is not enabled ([#641](https://github.com/laravel/jetstream/pull/641))
- Fix unique email on email invitations ([593e763](https://github.com/laravel/jetstream/commit/593e763f2eb07a7bdf7206fa497c22c5cb9c2938#), [a394153](https://github.com/laravel/jetstream/commit/a3941534ae9299a38a68bc2ad4f335b73861d43e))

## [v2.1.0 (2021-01-12)](https://github.com/laravel/jetstream/compare/v2.0.3...v2.1.0)

### Added

- Add `--composer` option to the install command ([#607](https://github.com/laravel/jetstream/pull/607))

### Changed

- Automatically select API token when it's created ([#589](https://github.com/laravel/jetstream/pull/589))
- Change current team of user when creating a new additional team ([#618](https://github.com/laravel/jetstream/pull/618))
- Make text translatable in confirm-password livewire view ([#628](https://github.com/laravel/jetstream/pull/628))

### Fixed

- Banner should be hidden in default ([#599](https://github.com/laravel/jetstream/pull/599))
- Jetstream ignoring sessions from session connection in config ([#630](https://github.com/laravel/jetstream/pull/630))

## [v2.0.3 (2021-01-06)](https://github.com/laravel/jetstream/compare/v2.0.2...v2.0.3)

### Added

- Allow publishing of missing Inertia files ([#596](https://github.com/laravel/jetstream/pull/596), [b28ee67](https://github.com/laravel/jetstream/commit/b28ee670590312d014448c2c8f2479ec264c64cc))

### Changed

- Make button text in team invitation email translatable ([#598](https://github.com/laravel/jetstream/pull/598))

### Removed

- Remove unused Vue components ([#596](https://github.com/laravel/jetstream/pull/596))

### Fixed

- Make a similar footer section on welcome page ([#602](https://github.com/laravel/jetstream/pull/602))

## [v2.0.2 (2021-01-06)](https://github.com/laravel/jetstream/compare/v2.0.1...v2.0.2)

### Fixed

- Fix test ([d24c41b](https://github.com/laravel/jetstream/commit/d24c41bca5fd69fa369915565a18ac2510b04928))

## [v2.0.1 (2021-01-06)](https://github.com/laravel/jetstream/compare/v2.0.0...v2.0.1)

### Changed

- Make cancel link translatable ([#592](https://github.com/laravel/jetstream/pull/592))

### Fixed

- Inertia Stack Authentication Page logo link update with inertia-link ([#594](https://github.com/laravel/jetstream/pull/594))

## [v2.0.0 (2021-01-05)](https://github.com/laravel/jetstream/compare/v1.6.6...v2.0.0)

A major new Jetstream release. Check out [the announcement post](https://blog.laravel.com/jetstream-20-released).

## [v1.6.6 (2021-01-05)](https://github.com/laravel/jetstream/compare/v1.6.5...v1.6.6)

### Changed

- Update to Laravel Mix v6 ([#582](https://github.com/laravel/jetstream/pull/582))

### Fixed

- Avoids eqeqeq errors in eslint ([#580](https://github.com/laravel/jetstream/pull/580))

## [v1.6.5 (2020-12-15)](https://github.com/laravel/jetstream/compare/v1.6.4...v1.6.5)

### Fixed

- Add missing import must verify email interface ([#529](https://github.com/laravel/jetstream/pull/529))
- Use named route for two-factor ([#528](https://github.com/laravel/jetstream/pull/528))

## [v1.6.4 (2020-12-08)](https://github.com/laravel/jetstream/compare/v1.6.3...v1.6.4)

### Changed

- Rename path to prefix for route config ([#504](https://github.com/laravel/jetstream/pull/504))

## [v1.6.3 (2020-12-01)](https://github.com/laravel/jetstream/compare/v1.6.2...v1.6.3)

### Fixed

- Clears any validation error message before re-displaying confirmation ([#487](https://github.com/laravel/jetstream/pull/487))

## [v1.6.2 (2020-11-24)](https://github.com/laravel/jetstream/compare/v1.6.1...v1.6.2)

### Fixed

- Use Alpine directly for guest layout ([#485](https://github.com/laravel/jetstream/pull/485))

## [v1.6.1 (2020-11-17)](https://github.com/laravel/jetstream/compare/v1.6.0...v1.6.1)

### Changed

- Use mix helper and remove CDNs  ([#450](https://github.com/laravel/jetstream/pull/450), [ca94bd5](https://github.com/laravel/jetstream/commit/ca94bd599f9874cf02b9e92ae4d91605fdc1441b))

### Fixed

- Fix feature toggles in Inertia ([#451](https://github.com/laravel/jetstream/pull/451), [#454](https://github.com/laravel/jetstream/pull/454))
- Update response status code to prevent method not allowed ([#456](https://github.com/laravel/jetstream/pull/456))

## [v1.6.0 (2020-11-03)](https://github.com/laravel/jetstream/compare/v1.5.3...v1.6.0)

### Added

- PHP 8 Support ([#416](https://github.com/laravel/jetstream/pull/416))

### Fixed

- Delete user tokens when user is deleted ([#406](https://github.com/laravel/jetstream/pull/406), [5bc500e](https://github.com/laravel/jetstream/commit/5bc500e65c69f9bee8667de9287d18369b24b793))
- Fix composer memory limit crashes ([#412](https://github.com/laravel/jetstream/pull/412))
- Update `TwoFactorAuthenticationForm.vue` ([#417](https://github.com/laravel/jetstream/pull/417))

## [v1.5.3 (2020-10-27)](https://github.com/laravel/jetstream/compare/v1.5.2...v1.5.3)

### Fixed

- Fix Livewire Modal Closing Issue By Bumping Alpine To `2.7.3` ([#404](https://github.com/laravel/jetstream/pull/404))
- Delete the users profile picture ([#399](https://github.com/laravel/jetstream/pull/399))

## [v1.5.2 (2020-10-27)](https://github.com/laravel/jetstream/compare/v1.5.1...v1.5.2)

### Added

- Adds custom redirects after creating or deleting a team ([#383](https://github.com/laravel/jetstream/pull/383), [ef3382d](https://github.com/laravel/jetstream/commit/ef3382d316b763211f25eaa7e1ba09ec373d0508))

### Changed

- Make team show use policies ([#379](https://github.com/laravel/jetstream/pull/379))
- Use ziggy current method to check active link ([#402](https://github.com/laravel/jetstream/pull/402))

### Fixed

- Add missing trait ([#385](https://github.com/laravel/jetstream/pull/385))
- Slot Empty Checking & Return Default Value ([#389](https://github.com/laravel/jetstream/pull/389))
- Constrain Ziggy version to `^0.9.4` ([#395](https://github.com/laravel/jetstream/pull/395))

## [v1.5.1 (2020-10-21)](https://github.com/laravel/jetstream/compare/v1.5.0...v1.5.1)

### Fixed

- Lock `inertiajs/inertia-laravel` to `^0.2.4` ([#371](https://github.com/laravel/jetstream/pull/371))

## [v1.5.0 (2020-10-20)](https://github.com/laravel/jetstream/compare/v1.4.1...v1.5.0)

### Added

- Add Jetstream route prefix config ([#362](https://github.com/laravel/jetstream/pull/362))

### Changed

- Added js directory path alias ([#328](https://github.com/laravel/jetstream/pull/328), [412e748](https://github.com/laravel/jetstream/commit/412e748649805ac32a50c01273bf073ef4b2aa6f))
- Update wording ([055be85](https://github.com/laravel/jetstream/commit/055be8529b4fb45897e9d5ef42eee0b2a45c8bde))

## [v1.4.1 (2020-10-13)](https://github.com/laravel/jetstream/compare/v1.4.0...v1.4.1)

### Changed

- Give user object to update profile information form ([#324](https://github.com/laravel/jetstream/pull/324), [d818b31](https://github.com/laravel/jetstream/commit/d818b31784bb29faaab6abefd3e7aab9a5d4dce1))
- Numeric keyboard in Two Factor Challenge ([#336](https://github.com/laravel/jetstream/pull/336))

### Fixed

- Correct visibility of Fortify features in profile view ([#322](https://github.com/laravel/jetstream/pull/322))
- Fix incorrect variable ([afc89ad](https://github.com/laravel/jetstream/commit/afc89ad834d179dd39a0b86815b48dac8f039f69))

## [v1.4.0 (2020-10-06)](https://github.com/laravel/jetstream/compare/v1.3.2...v1.4.0)

### Changed

- Extract switch team logic into HasTeams trait ([#312](https://github.com/laravel/jetstream/pull/312))
- Use named routes on Inertia with Ziggy ([#314](https://github.com/laravel/jetstream/pull/314), [#316](https://github.com/laravel/jetstream/pull/316))
- Bump Tailwind & Inertia ([#315](https://github.com/laravel/jetstream/pull/315))

## [v1.3.2 (2020-10-05)](https://github.com/laravel/jetstream/compare/v1.3.1...v1.3.2)

### Changed

- Add dependency-less modal focus trapping ([#294](https://github.com/laravel/jetstream/pull/294))
- Use `getAuthIdentifier` instead of `getKey` ([#283](https://github.com/laravel/jetstream/pull/283))
- Ensure text remains visible during webfont load ([#290](https://github.com/laravel/jetstream/pull/290))
- Make terms translatable ([#300](https://github.com/laravel/jetstream/pull/300))
- Disable profile photo and api by default ([096d7dd](https://github.com/laravel/jetstream/commit/096d7dd6e4cbbfb67206ce8c03befbdfbec0595e))

### Fixed

- a11y(auth): associate inputs with labels ([#285](https://github.com/laravel/jetstream/pull/285))

## [v1.3.1 (2020-09-29)](https://github.com/laravel/jetstream/compare/v1.3.0...v1.3.1)

### Changed

- Bump Alpine.js version up to 2.7.0 ([#262](https://github.com/laravel/jetstream/pull/262))

### Fixed

- Use session table from the config ([#265](https://github.com/laravel/jetstream/pull/265))
- Add `:key` buildings for list (for) rendering to `TeamMemberManager.vue` ([#270](https://github.com/laravel/jetstream/pull/270))
- Add Submenu Style For When Profile Photos Are Unmanaged ([#275](https://github.com/laravel/jetstream/pull/275), [e717c9e](https://github.com/laravel/jetstream/commit/e717c9e89d5757e12167fa0b729657ecae12fd61))
- Disable save button while profile pic is uploading ([#266](https://github.com/laravel/jetstream/pull/266))

## [v1.3.0 (2020-09-22)](https://github.com/laravel/jetstream/compare/v1.2.1...v1.3.0)

### Added

- Added hasTeamRole check on the HasTeams trait ([#251](https://github.com/laravel/jetstream/pull/251), [87b4bf3](https://github.com/laravel/jetstream/commit/87b4bf356387a66f87a90712f0aa4a1ce3c13126))

### Changed

- More translation support ([#211](https://github.com/laravel/jetstream/pull/211), [#216](https://github.com/laravel/jetstream/pull/216))
- Use `mix()` instead of `asset()` for hot-reload support ([#217](https://github.com/laravel/jetstream/pull/217))
- Remove Hard Coded Livewire Routes ([#226](https://github.com/laravel/jetstream/pull/226))
- Update `UpdateUserProfileInformation.php` ([#247](https://github.com/laravel/jetstream/pull/247))

### Fixed

- Fixed attribute order inside views ([#207](https://github.com/laravel/jetstream/pull/207))
- Update modal z-index ([#212](https://github.com/laravel/jetstream/pull/212))
- Add key of v-for teams ([#239](https://github.com/laravel/jetstream/pull/239))
- Correct ID value for email field ([#240](https://github.com/laravel/jetstream/pull/240))
- Fix purging of CSS classes on production builds ([#249](https://github.com/laravel/jetstream/pull/249))
- Fix migration ([1883071](https://github.com/laravel/jetstream/commit/1883071d771193e59ef7ed4509576e9b853dac43))

## [v1.2.1 (2020-09-15)](https://github.com/laravel/jetstream/compare/v1.2.0...v1.2.1)

### Added

- Add delete profile photo button ([#110](https://github.com/laravel/jetstream/pull/110), [785dcdfa](https://github.com/laravel/jetstream/commit/785dcdfa2a4aa839b7638969ee58dbe3eb763980), [69f5c8d](https://github.com/laravel/jetstream/commit/69f5c8d35a76a811ac3e51749e788be51792a107), [c51e5cf](https://github.com/laravel/jetstream/commit/c51e5cf6ad41c695b62bf10304a7c20a62dddafe))

### Fixed

- Don't include update password form if feature disabled ([#197](https://github.com/laravel/jetstream/pull/197))
- Remove hard coded routes and use `route()` helper by name instead ([#203](https://github.com/laravel/jetstream/pull/203))
- Fix button margins on small screens ([#206](https://github.com/laravel/jetstream/pull/206))

## [v1.2.0 (2020-09-14)](https://github.com/laravel/jetstream/compare/v1.1.2...v1.2.0)

### Added

- Confirmable Support ([#196](https://github.com/laravel/jetstream/pull/196), [c1ff4a5](https://github.com/laravel/jetstream/commit/c1ff4a55fccf674958a3b0ef5ec97cea81ad4501))

### Changed

- Update Fortify Actions to use PasswordValidationRules Trait ([#168](https://github.com/laravel/jetstream/pull/168))
- Make labels translatable in livewire views ([#177](https://github.com/laravel/jetstream/pull/177))
- A few more strings that should be translatable ([#192](https://github.com/laravel/jetstream/pull/192))

### Fixed

- Refresh navigation dropdown when teams/profile forms save ([#132](https://github.com/laravel/jetstream/pull/132))
- Fix API token deletion bug ([#155](https://github.com/laravel/jetstream/pull/155))
- Fix profile picture distortion for team owners ([#165](https://github.com/laravel/jetstream/pull/165))
- Fix HasTeams trait to be able to use queries ([#173](https://github.com/laravel/jetstream/pull/173))

## [v1.1.2 (2020-09-10)](https://github.com/laravel/jetstream/compare/v1.1.1...v1.1.2)

### Changed

- Set fully url forget and reset password action ([#136](https://github.com/laravel/jetstream/pull/136))

### Fixed

- Missing Closing Parenthesis ([#140](https://github.com/laravel/jetstream/pull/140))

## [v1.1.1 (2020-09-10)](https://github.com/laravel/jetstream/compare/v1.1.0...v1.1.1)

### Fixed

- Fix missing request ([#137](https://github.com/laravel/jetstream/pull/137))

## [v1.1.0 (2020-09-10)](https://github.com/laravel/jetstream/compare/v1.0.2...v1.1.0)

### Added

- Add alt attribute/value to image tag ([#106](https://github.com/laravel/jetstream/pull/106))
- Translates more strings ([#101](https://github.com/laravel/jetstream/pull/101))

### Changed

- Use static properties for Team and Membership too ([#119](https://github.com/laravel/jetstream/pull/119), [#121](https://github.com/laravel/jetstream/pull/121))
- Add inertia render hooks ([b2e5729](https://github.com/laravel/jetstream/commit/b2e57294ada600164f5c098b5e0abd1e38f89133), [fd76d88](https://github.com/laravel/jetstream/commit/fd76d8816964388edb4aad988fa9b0659b2e89c7), [4929383](https://github.com/laravel/jetstream/commit/4929383bd98f49885059ec63a702f17b34bc90ce))

### Fixed

- Fix for `vendor:publish` routes ([#109](https://github.com/laravel/jetstream/pull/109))
- Make team menu entry "truncate" ([#114](https://github.com/laravel/jetstream/pull/114))
- Added object-cover to profile images ([#122](https://github.com/laravel/jetstream/pull/122))
- Inertia: Use check instead of authorize for canCreateTeams ([#129](https://github.com/laravel/jetstream/pull/129))

## [v1.0.2 (2020-09-08)](https://github.com/laravel/jetstream/compare/v1.0.1...v1.0.2)

### Changed

- Update sessions table ([49a6815](https://github.com/laravel/jetstream/commit/49a6815c7f0e5bb18261c7a0df86a3799328f3b3))
- Fix `ownsTeam` check ([65ce882](https://github.com/laravel/jetstream/commit/65ce8824a8a5a631a9cc02595655b8699bf4b086))

## [v1.0.1 (2020-09-08)](https://github.com/laravel/jetstream/compare/v1.0.0...v1.0.1)

### Changed

- Update to Laravel Fortify 1.0 ([#96](https://github.com/laravel/jetstream/pull/96))

## [v1.0.0 (2020-09-08)](https://github.com/laravel/jetstream/compare/v0.7.3...v1.0.0)

### Fixed

- Fix modal ([47ad018](https://github.com/laravel/jetstream/commit/47ad018841941bf054d1502f36392f5a817fe4f4))

## [v0.7.3 (2020-09-08)](https://github.com/laravel/jetstream/compare/v0.7.2...v0.7.3)

### Fixed

- Fix bugs with method names ([d85870d](https://github.com/laravel/jetstream/commit/d85870dad5f57d565a1534746c9158debc7b4af1), [54a3db6](https://github.com/laravel/jetstream/commit/54a3db67735df017ceab8f1aec6b3a37218edb42))

## [v0.7.2 (2020-09-08)](https://github.com/laravel/jetstream/compare/v0.7.1...v0.7.2)

### Fixed

- Revert layout changes ([915c797](https://github.com/laravel/jetstream/commit/915c797fdc345822af188ba044e42997ec577419))

## [v0.7.1 (2020-09-08)](https://github.com/laravel/jetstream/compare/v0.7.0...v0.7.1)

### Added

- Implement TeamPolicy::create authorization check before creating a team ([#82](https://github.com/laravel/jetstream/pull/82), [42ed0aa](https://github.com/laravel/jetstream/commit/42ed0aabfabc2fa6ae741ef2b67f936c598fd05f))
- Provide a way of customizing/disabling the default routes ([#67](https://github.com/laravel/jetstream/pull/67))
- Delete User password confirmation ([#91](https://github.com/laravel/jetstream/pull/91))

### Changed

- Make auth views translatable ([#81](https://github.com/laravel/jetstream/pull/81))

### Fixed

- Fix API vs Web TeamsHasPermissions, add Tests ([#89](https://github.com/laravel/jetstream/pull/89))
- Fix "remember me" checkbox ([#86](https://github.com/laravel/jetstream/pull/86))
- Fix `InstallCommand.php` ([#55](https://github.com/laravel/jetstream/pull/55))

## [v0.7.0 (2020-09-06)](https://github.com/laravel/jetstream/compare/v0.6.4...v0.7.0)

### Changed

- Set fully qualified URL for login,register and logout ([#49](https://github.com/laravel/jetstream/pull/49))
- Use application language on layouts ([#58](https://github.com/laravel/jetstream/pull/58))
- Use incrementing ids for team ids ([71b67f1](https://github.com/laravel/jetstream/commit/71b67f1e04f6c06741b910ff999aa6370b3ba970))

## [v0.6.4 (2020-09-04)](https://github.com/laravel/jetstream/compare/v0.6.3...v0.6.4)

### Fixed

- Fix disk ([f00615f](https://github.com/laravel/jetstream/commit/f00615f26d59e7adf16c889207c054ab079f462a))

## [v0.6.3 (2020-09-04)](https://github.com/laravel/jetstream/compare/v0.6.2...v0.6.3)

### Changed

- Update photo storage ([b304f4e](https://github.com/laravel/jetstream/commit/b304f4ec3ccd7052317393f0655bc4a6e3f7b8ef))

## [v0.6.2 (2020-09-04)](https://github.com/laravel/jetstream/compare/v0.6.1...v0.6.2)

### Changed

- Change how auth guards are setup ([6ac870f](https://github.com/laravel/jetstream/commit/6ac870f0af7aee4e6cf835771093e8466576cca2))

## [v0.6.1 (2020-09-04)](https://github.com/laravel/jetstream/compare/v0.6.0...v0.6.1)

### Changed

- Set a fully qualified URL for css file ([#27](https://github.com/laravel/jetstream/pull/27))
- Allow using Inertia without a session ([#43](https://github.com/laravel/jetstream/pull/43))
- Make error message translatable ([#39](https://github.com/laravel/jetstream/pull/39))

## [v0.6.0 (2020-09-04)](https://github.com/laravel/jetstream/compare/v0.0.5...v0.6.0)

### Changed

- Support Livewire V2 ([#23](https://github.com/laravel/jetstream/pull/23), [b99cbd7](https://github.com/laravel/jetstream/commit/b99cbd727b1f247f9b47937b3c87de0f863e46f9))

## [v0.0.5 (2020-09-02)](https://github.com/laravel/jetstream/compare/v0.0.4...v0.0.5)

### Changed

- Change divs to buttons ([#8](https://github.com/laravel/jetstream/pull/8))
- Replace the "home" route by the "dashboard" route ([#16](https://github.com/laravel/jetstream/pull/16))
- Include autocomplete on all relevant elements ([#13](https://github.com/laravel/jetstream/pull/13))
- Configure Purgecss for Tailwind ([#10](https://github.com/laravel/jetstream/pull/10), [af9bba5](https://github.com/laravel/jetstream/commit/af9bba58050c53b4b339178d08129ba105e861d0))
- Use numeric ids for users ([#22](https://github.com/laravel/jetstream/pull/22))

## [v0.0.4 (2020-09-01)](https://github.com/laravel/jetstream/compare/v0.0.3...v0.0.4)

### Changed

- Use inertia link ([991457c](https://github.com/laravel/jetstream/commit/991457c8858090c2d661b33cbb8a0a7cfa73ab45))

## [v0.0.3 (2020-09-01)](https://github.com/laravel/jetstream/compare/v0.0.2...v0.0.3)

### Changed

- Update guard usage ([e871b88](https://github.com/laravel/jetstream/commit/e871b887e01f71c347aae41c2a8d756b4d59a42e))

## [v0.0.2 (2020-09-01)](https://github.com/laravel/jetstream/compare/v0.0.1...v0.0.2)

### Changed

- Require Sanctum 2.6 ([#2](https://github.com/laravel/jetstream/pull/2))

## v0.0.1 (2020-08-31)

Initial release.
