
Livewire's ability to make updates to the page is what makes it "live", however, there are times where you might want to prevent Livewire from updating a portion of the page.

In these cases, you can use the `wire:ignore` directive to instruct Livewire to ignore the contents of a particular element, even if they change between requests.

This is most useful in the context of working with third-party javascript libraries for custom form inputs and such.

Below is an example of wrapping an element used by a third-party library in `wire:ignore` so that Livewire doesn't tamper with the HTML generated by the library:

```blade
<form>
    <!-- ... -->

    <div wire:ignore>
        <!-- This element would be reference by a -->
        <!-- third-party library for initialization... -->
        <input id="id-for-date-picker-library">
    </div>

    <!-- ... -->
</form>
```

You can also instruct Livewire to only ignore changes to attributes of the root element rather than observing changes to it's contents using `wire:ignore.self`.

```blade
<div wire:ignore.self>
    <!-- ... -->
</div>
```
