import { callAndClearComponentDebounces } from '@/debounce'
import { getDirectives } from '@/directives'
import { on } from '@/events'
import Alpine from 'alpinejs'

on('directive.init', ({ el, directive, cleanup, component }) => {
    if (['snapshot', 'effects', 'model', 'init', 'loading', 'poll', 'ignore', 'id', 'data', 'key', 'target', 'dirty'].includes(directive.value)) return

    let attribute = directive.rawName.replace('wire:', 'x-on:')

    // Automatically add .prevent to wire:submit, if they didn't add it themselves...
    if (directive.value === 'submit' && ! directive.modifiers.includes('prevent')) {
        attribute = attribute + '.prevent'
    }

    let cleanupBinding = Alpine.bind(el, {
        [attribute](e) {
            let execute = () => {
                callAndClearComponentDebounces(component, () => {
                    // Forward these calls directly to $wire. Let them handle firing the request.
                    Alpine.evaluate(el, '$wire.'+directive.expression, { scope: { $event: e }})
                })
            }

            // Account for the existance of wire:confirm="..." on the action...
            if (el.__livewire_confirm) {
                el.__livewire_confirm(() => {
                    execute()
                })
            } else {
                execute()
            }
        }
    })

    cleanup(cleanupBinding)
})
